/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell.ExportXmlDialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.dialogs.ExportXmlDialog;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class ExportAnnotatedToXmlButtonActionListener
implements ActionListener {
    private ExportXmlDialog exportXmlDialog;

    public ExportAnnotatedToXmlButtonActionListener(ExportXmlDialog exportXmlDialog) {
        this.exportXmlDialog = exportXmlDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String dName;
        File dir;
        String[] xmlAnnotations;
        if (this.exportXmlDialog.getRdbtnAllSyntax().isSelected()) {
            xmlAnnotations = new String[]{"<SYNTAX>"};
        } else {
            int i;
            int nbOfAnnotations = 0;
            ArrayList<String> tmp = new ArrayList<String>();
            String cbSelectedText = this.exportXmlDialog.getCobxXmlAnnotations().getSelectedItem().toString();
            for (i = 0; i < cbSelectedText.length(); ++i) {
                if (!cbSelectedText.substring(i, i + 1).equals("<")) continue;
                int j = 0;
                while (i + j < cbSelectedText.length() && !cbSelectedText.substring(i + j, i + j + 1).equals(">")) {
                    ++j;
                }
                tmp.add(cbSelectedText.substring(i, i + j + 1));
                if (++nbOfAnnotations >= 3) break;
                i += j;
            }
            if (tmp.size() == 0) {
                xmlAnnotations = null;
            } else {
                xmlAnnotations = new String[tmp.size()];
                for (i = 0; i < tmp.size(); ++i) {
                    xmlAnnotations[i] = (String)tmp.get(i);
                }
            }
            if (xmlAnnotations == null || xmlAnnotations.length == 0) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please enter annotations as XML tags, e.g. <DATE> or <NP>", "NooJ: no tag to export", 1);
                return;
            }
            for (i = 0; i < xmlAnnotations.length; ++i) {
                if (!xmlAnnotations[i].equals("<TRANS>")) continue;
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Special annotation <TRANS> requires a text field, e.g. <TRANS+FR> or <TRANS+PREDICATE>", "NooJ: no text field to use for translation", 1);
                return;
            }
        }
        TextEditorShellController textController = this.exportXmlDialog.getTextController();
        String xmlFileName = null;
        if (Launcher.projectMode) {
            dir = new File(Paths.projectDir);
            dName = dir.getParent();
            xmlFileName = dName + System.getProperty("file.separator") + FilenameUtils.removeExtension(textController.getTextName()) + ".xml.txt";
        } else {
            dir = new File(Paths.docDir);
            dName = dir + System.getProperty("file.separator") + textController.getMyText().Lan.isoName + System.getProperty("file.separator") + "Projects";
            xmlFileName = dName + System.getProperty("file.separator") + FilenameUtils.removeExtension(textController.getTextName()) + ".xml.txt";
        }
        Ntext text = textController.getMyText();
        Language lan = text.getLanguage();
        this.exportXmlAnnotations(xmlFileName, text, text.annotations, xmlAnnotations, true, this.exportXmlDialog.getChbxOnly().isSelected(), lan);
    }

    private void exportXmlAnnotations(String xmlFileName, Ntext text, ArrayList<Object> annotations, String[] xmlAnnotations, boolean interactive, boolean filterOut, Language lan) {
        PrintWriter pw = null;
        try {
            File xmlFile = new File(xmlFileName);
            xmlFile.createNewFile();
            pw = new PrintWriter(xmlFileName);
            int currentAddress = 0;
            for (int itu = 1; itu <= text.nbOfTextUnits; ++itu) {
                if (currentAddress < text.mft.tuAddresses[itu] && !filterOut) {
                    pw.write(text.buffer.substring(currentAddress, text.mft.tuAddresses[itu]));
                }
                String currentLine = text.buffer.substring(text.mft.tuAddresses[itu], text.mft.tuLengths[itu] + text.mft.tuAddresses[itu]);
                currentAddress = text.mft.tuLengths[itu] + text.mft.tuAddresses[itu];
                text.buildXmlTaggedText(currentLine, 0, filterOut, pw, itu, annotations, xmlAnnotations, lan, false);
            }
            if (!filterOut) {
                pw.write(text.buffer.substring(currentAddress));
            }
            pw.close();
            if (interactive) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: text has been exported into file " + xmlFileName, "ONooJ", 1);
                return;
            }
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: cannot create file " + xmlFileName, 0);
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while exporting corpus to XML!", 0);
            return;
        }
    }
}

